﻿if ((Get-WindowsFeature Web-Server).InstallState -eq "Installed") {
Write-Host "IIS is installed"

Import-Module WebAdministration

Start-IISCommitDelay

$siteName = "Default Web Site"
$sitesCollection = Get-IISConfigSection -SectionPath "system.applicationHost/sites" | Get-IISConfigCollection 
$siteElement = Get-IISConfigCollectionElement -ConfigCollection $sitesCollection -ConfigAttribute @{"name"="$siteName"} 
$hstsElement = Get-IISConfigElement -ConfigElement $siteElement -ChildElementName "hsts" 

Set-IISConfigAttributeValue -ConfigElement $hstsElement -AttributeName "enabled" -AttributeValue $true 
Set-IISConfigAttributeValue -ConfigElement $hstsElement -AttributeName "max-age" -AttributeValue 31536000 
Set-IISConfigAttributeValue -ConfigElement $hstsElement -AttributeName "includeSubDomains" -AttributeValue $true 
Set-IISConfigAttributeValue -ConfigElement $hstsElement -AttributeName "redirectHttpToHttps" -AttributeValue $true 
Set-IISConfigAttributeValue -ConfigElement $hstsElement -AttributeName "preload" -AttributeValue $true 

Stop-IISCommitDelay

Remove-Module IISAdministration

exit

}

else {

Write-Host "IIS is not installed"

}

exit

